local KEYP1 = GLOBAL.KEY_CTRL
--not (0.5 range (resolution?))
local KEYP2 = GLOBAL.KEY_P
--0.1 range (resolution?)
local Vector3 = GLOBAL.Vector3
local TheInput = GLOBAL.TheInput
local GROUND = GLOBAL.GROUND


----------placer-----
local function newOnUpdate(self, dt)
	local pt = TheInput:GetWorldPosition()

	if self.snap_to_tile and GLOBAL.GetWorld().Map then
		local pt2 = Vector3(GLOBAL.GetWorld().Map:GetTileCenterPoint(pt:Get()))
		pt = pt2
	elseif self.snap_to_meters then
		pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
--------------------<MOD<----------------------
	elseif TheInput:IsKeyDown(KEYP2) then
		pt = Vector3( pt.x+.05-(pt.x+.05)%.1, 0, pt.z+.05-(pt.z+.05)%.1)
	elseif not TheInput:IsKeyDown(KEYP1) then
		pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
-------------------->MOD>----------------------
	end
	
	self.inst.Transform:SetPosition(pt:Get())	
	
	self.can_build = true
	if self.testfn then
		self.can_build = self.testfn(Vector3(self.inst.Transform:GetWorldPosition()))
	end
	
	self.inst.AnimState:SetMultColour(0,0,0,.5)
	
	local color = self.can_build and Vector3(.1,.5,.1) or Vector3(.5,.1,.1)
	self.inst.AnimState:SetAddColour(color.x, color.y, color.z ,0)
	
end

local function geomplace(inst)
	inst.OnUpdate = newOnUpdate
end




----------builder-----
local function newCanBuildAtPoint(self, pt, recipe)

	local ground = GLOBAL.GetWorld()
    local tile = GROUND.GRASS
    if ground and ground.Map then
        tile = ground.Map:GetTileAtPoint(pt:Get())
    end

	if tile == GROUND.IMPASSABLE then
		return false
	else
		local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 6) -- or we could include a flag to the search?
		for k, v in pairs(ents) do
			if v ~= self.inst and (not v.components.placer) and not v:HasTag("player") and not v:HasTag("FX") and v.entity:IsVisible() and not (v.components.inventoryitem and v.components.inventoryitem.owner )then
				local min_rad = recipe.min_spacing or 2+1.2
				--local rad = (v.Physics and v.Physics:GetRadius() or 1) + 1.25
				local dsq = GLOBAL.distsq(Vector3(v.Transform:GetWorldPosition()), pt)
--------------------<MOD<----------------------
				--if dsq <= min_rad*min_rad then
				if dsq < min_rad*min_rad then
-------------------->MOD>----------------------
					return false
				end
			end
		end
	end
	
	return true
end
local function newMakeRecipe(self, recipe, pt, onsuccess)
    if recipe then
    	self.inst:PushEvent("makerecipe", {recipe = recipe})
		pt = pt or Point(self.inst.Transform:GetWorldPosition())
--------------------<MOD<----------------------
		if TheInput:IsKeyDown(KEYP2) then
			pt = Vector3( pt.x+.05-(pt.x+.05)%.1, 0, pt.z+.05-(pt.z+.05)%.1)
		elseif not TheInput:IsKeyDown(KEYP1) then
			pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
		end
-------------------->MOD>----------------------
		if self:IsBuildBuffered(recipe.name) or self:CanBuild(recipe.name) then
			self.inst.components.locomotor:Stop()
			local buffaction = GLOBAL.BufferedAction(self.inst, nil, GLOBAL.ACTIONS.BUILD, nil, pt, recipe.name, 1)
			if onsuccess then
				buffaction:AddSuccessAction(onsuccess)
			end
			
			self.inst.components.locomotor:PushAction(buffaction, true)
			
			return true
		end
    end
    return false
end

local function geombuild(inst)
	inst.CanBuildAtPoint = newCanBuildAtPoint
	inst.MakeRecipe = newMakeRecipe
end





----------deployable-----
local function newCanDeploy(self, pt)
--------------------<MOD<----------------------
	if not TheInput:IsKeyDown(KEYP1) then
		pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
	end
-------------------->MOD>----------------------
    return not self.test or self.test(self.inst, pt)
end

local function newDeploy(self, pt, deployer)
--------------------<MOD<----------------------
	if not TheInput:IsKeyDown(KEYP1) then
		pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
	end
-------------------->MOD>----------------------
    if not self.test or self.test(self.inst, pt, deployer) then
		if self.ondeploy then
	        self.ondeploy(self.inst, pt, deployer)
		end
		return true
	end
end

local function geomdeploy(inst)
	inst.CanDeploy = newCanDeploy
	inst.Deploy = newDeploy
end


AddComponentPostInit("placer", geomplace)
AddComponentPostInit("builder", geombuild)
AddComponentPostInit("deployable", geomdeploy)
